/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.example.PrintableImage;

public class DisplayImage
extends JFrame {
    private final BufferedImage image;

    public DisplayImage(BufferedImage image) {
        this.image = image;
        this.initUI();
        this.setDefaultCloseOperation(2);
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void initUI() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(new JLabel(new ImageIcon(this.image)));
        contentPanel.add((Component)scrollPane, "Center");
        JPopupMenu popupMenu = this.createPopupMenu();
        JLabel imageLabel = (JLabel)scrollPane.getViewport().getView();
        imageLabel.setComponentPopupMenu(popupMenu);
        this.setContentPane(contentPanel);
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem saveItem = new JMenuItem("Save Image");
        saveItem.addActionListener(e -> this.saveImage());
        popupMenu.add(saveItem);
        JMenuItem printItem = new JMenuItem("Print Image");
        printItem.addActionListener(e -> this.printImage());
        popupMenu.add(printItem);
        return popupMenu;
    }

    private void saveImage() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Save Image");
        int userSelection = fileChooser.showSaveDialog(this);
        if (userSelection == 0) {
            File fileToSave = fileChooser.getSelectedFile();
            try {
                ImageIO.write((RenderedImage)this.image, "png", fileToSave);
                JOptionPane.showMessageDialog(this, "Image saved successfully!");
            }
            catch (IOException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error saving image");
            }
        }
    }

    private void printImage() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(new PrintableImage(this.image));
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error printing image");
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

