/*
 * Decompiled with CFR 0.152.
 */
package org.example.engine;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.example.configuration.BusinessTripForm;
import org.example.configuration.IConfiguration;
import org.example.configuration.IOrderAdditionalDaysCoordinates;
import org.example.configuration.IOrderTextCoordinates;
import org.example.engine.DataManager;
import org.example.engine.ImgData;
import org.example.engine.TextCords;
import org.example.utillity.ExpenseCalculator;
import org.example.utillity.ImageDrawer;

public class OrderListDataManager {
    private final BusinessTripForm form;
    private final List<BufferedImage> sheetStorage;
    private final IConfiguration configuration;
    private final IOrderTextCoordinates coordinates;
    private final IOrderAdditionalDaysCoordinates orderAdditionalDaysCoordinates;
    BufferedImage blankImage;
    BufferedImage blankAdditionalOrderDaysImage;

    public OrderListDataManager(BusinessTripForm form, List<BufferedImage> sheetStorage, IConfiguration configuration, IOrderTextCoordinates coordinates, IOrderAdditionalDaysCoordinates orderAdditionalDaysCoordinates) {
        block17: {
            this.form = form;
            this.sheetStorage = sheetStorage;
            this.configuration = configuration;
            this.coordinates = coordinates;
            this.orderAdditionalDaysCoordinates = orderAdditionalDaysCoordinates;
            if (!configuration.orderImgResourcePath().isPresent()) {
                throw new RuntimeException("Order Img Resource path is null/empty.");
            }
            if (!configuration.additionalDaysImgResourcePath().isPresent()) {
                throw new RuntimeException("Additional Days Img Resource Path is null/empty.");
            }
            try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(configuration.orderImgResourcePath().get());
                 InputStream inputAddOrderDaysStream = this.getClass().getClassLoader().getResourceAsStream(configuration.additionalDaysImgResourcePath().get());){
                if (inputStream != null) {
                    this.blankImage = ImageIO.read(inputStream);
                    this.blankAdditionalOrderDaysImage = ImageIO.read(inputAddOrderDaysStream);
                    break block17;
                }
                throw new RuntimeException("Image resource not found");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void getTripWithoutVehicleWithoutHotel() {
        DataManager dataManager = new DataManager(this.form, this.commonOrderData());
        dataManager.dataAdder(this.coordinates.dailyMoneyCoordinates(), String.valueOf(this.configuration.getDailyMoneyWithoutHotel()));
        this.sheetStorage.add(ImageDrawer.drawDataOnBackgroundImg(dataManager.data, this.blankImage, this.configuration.getFont(), this.configuration.getFontColor()));
    }

    public void getTripWithOtherTransportWithoutHotel() {
        DataManager dataManager = new DataManager(this.form, this.commonOrderData());
        dataManager.dataAdder(this.coordinates.dailyMoneyCoordinates(), String.valueOf(this.configuration.getDailyMoneyWithoutHotel()));
        this.numberOfOrdersCreation(this.form.getDays(), dataManager.data);
    }

    public void getTripWithOtherTransportWithHotel() {
        DataManager dataManager = new DataManager(this.form, this.commonOrderData());
        if (this.form.getIsTravelOnLastDay()) {
            dataManager.dataAdder(this.coordinates.dailyMoneyCoordinates(), "    /" + this.configuration.getDailyMoneyWithoutHotel());
        }
        dataManager.dataAdder(this.coordinates.dailyMoneyCoordinates(), String.valueOf(this.configuration.getDailyMoneyWithHotel()));
        if (this.form.getNightStayPrice().compareTo(BigDecimal.ZERO) > 0) {
            dataManager.dataAdder(this.coordinates.nightStayMoneyCoordinates(), String.format("%.2f", this.form.getNightStayPrice()));
        }
        this.sheetStorage.add(ImageDrawer.drawDataOnBackgroundImg(dataManager.data, this.blankImage, this.configuration.getFont(), this.configuration.getFontColor()));
    }

    public void getTripWithoutVehicleWithHotel() {
        DataManager dataManager = new DataManager(this.form, this.commonOrderData());
        if (this.form.getIsTravelOnLastDay()) {
            dataManager.dataAdder(this.coordinates.dailyMoneyCoordinates(), "    /" + this.configuration.getDailyMoneyWithoutHotel());
        }
        dataManager.dataAdder(this.coordinates.dailyMoneyCoordinates(), String.valueOf(this.configuration.getDailyMoneyWithHotel()));
        dataManager.dataAdder(this.coordinates.nightStayMoneyCoordinates(), String.format("%.2f", this.form.getNightStayPrice()));
        this.sheetStorage.add(ImageDrawer.drawDataOnBackgroundImg(dataManager.data, this.blankImage, this.configuration.getFont(), this.configuration.getFontColor()));
    }

    public void getTripWithVehicleWithoutHotel() {
        DataManager orderDataManager = new DataManager(this.form, this.commonOrderDataWithVehicle());
        orderDataManager.dataAdder(this.coordinates.dailyMoneyCoordinates(), String.valueOf(this.configuration.getDailyMoneyWithoutHotel()));
        this.numberOfOrdersCreation(this.form.getDays(), orderDataManager.data);
    }

    public void getTripWithVehicleWithHotel() {
        DataManager dataManager = new DataManager(this.form, this.commonOrderDataWithVehicle());
        dataManager.dataAdder(this.coordinates.dailyMoneyCoordinates(), String.valueOf(this.configuration.getDailyMoneyWithHotel()));
        dataManager.dataAdder(this.coordinates.nightStayMoneyCoordinates(), String.format("%.2f", this.form.getNightStayPrice()));
        if (this.form.getIsTravelOnLastDay()) {
            dataManager.dataAdder(this.coordinates.departedDateCoordinates().get(0), String.format("%02d.%02d.%d", this.form.getDays().get(this.form.getDays().size() - 1), Integer.parseInt(this.form.getMonthNumber()), Integer.parseInt(this.form.getWhatYear())));
            dataManager.dataAdder(this.coordinates.dailyMoneyCoordinates(), "    /" + this.configuration.getDailyMoneyWithoutHotel());
        }
        if (this.form.getIsTravelOnFirstDay()) {
            dataManager.dataAdder(this.coordinates.arrivedDateCoordinates().get(0), String.format("%02d.%02d.%d", this.form.getDays().get(0), Integer.parseInt(this.form.getMonthNumber()), Integer.parseInt(this.form.getWhatYear())));
            dataManager.dataAdder(this.coordinates.destinationCoordinates().get(0), this.form.getEndDestination());
        }
        this.sheetStorage.add(ImageDrawer.drawDataOnBackgroundImg(dataManager.data, this.blankImage, this.configuration.getFont(), this.configuration.getFontColor()));
    }

    private List<ImgData> commonOrderDataWithVehicle() {
        DataManager dataManager = new DataManager(this.form, this.commonOrderData());
        dataManager.dataAdder(this.coordinates.vehicleMakeCoordinates(), this.form.getMake());
        dataManager.dataAdder(this.coordinates.vehicleRegNumberCoordinates(), this.form.getRegistrationNumber());
        dataManager.dataAdder(this.coordinates.fuelTypeCoordinates(), this.form.getFuelType());
        dataManager.dataAdder(this.coordinates.typeMPSCoordinates(), this.form.getCategory());
        BigDecimal totalFuelExpenses = ExpenseCalculator.calculateTotalFuelPrice(this.form.getKilometers(), this.form.getCostBy100(), this.form.getFuelPrice());
        if (totalFuelExpenses.compareTo(BigDecimal.ZERO) > 0) {
            dataManager.dataAdder(this.coordinates.fuelConsumptionFor100Coordinates(), String.valueOf(this.form.getCostBy100()));
            dataManager.dataAdder(this.coordinates.fuelPriceCoordinates(), String.format("%.2f", this.form.getFuelPrice()));
            dataManager.dataAdder(this.coordinates.kilometersCoordinates(), this.form.getKilometers().toString());
            dataManager.dataAdder(this.coordinates.kilometersDividedBy100Coordinates(), String.format("%.2f", this.form.getKilometers().divide(BigDecimal.valueOf(100.0), 2, RoundingMode.FLOOR)));
            dataManager.dataAdder(this.coordinates.totalSumForTransportCoordinates(), String.format("%.2f", totalFuelExpenses.setScale(2, RoundingMode.FLOOR)));
            BigDecimal fuelConsumed = ExpenseCalculator.calculateFuelConsumed(this.form.getKilometers(), this.form.getCostBy100());
            dataManager.dataAdder(this.coordinates.totalFuelConsumedCoordinates(), String.valueOf(fuelConsumed.setScale(2, RoundingMode.FLOOR)));
        }
        return dataManager.data;
    }

    private List<ImgData> commonOrderData() {
        DataManager dataManager = new DataManager(this.form, new ArrayList<ImgData>());
        dataManager.dataAdder(this.coordinates.fullNameCoordinates(), this.form.getFullName());
        dataManager.dataAdder(this.coordinates.fullNameAndEmployeePositionCoordinates(), String.format("%s, %s", this.form.getFullName().trim().isEmpty() ? "                                          " : this.form.getFullName(), this.form.getPosition()));
        dataManager.dataAdder(this.coordinates.numberDocumentsCoordinates(), String.valueOf(this.form.getNumberDocuments() == 0 ? "" : Integer.valueOf(this.form.getNumberDocuments())));
        if (this.form.getIsTravelOnLastDay()) {
            dataManager.dataAdder(this.coordinates.startCityCoordinates(), this.form.getStartDestination());
        }
        dataManager.dataAdder(this.coordinates.endCityCoordinates(), this.form.getEndDestination());
        dataManager.dataAdder(this.coordinates.numberOfDaysCoordinates(), String.valueOf(this.form.getNumberOfDays()));
        dataManager.dataAdder(this.coordinates.startDateCoordinates(), String.format("%02d.%02d.%d", this.form.getDays().get(0), Integer.parseInt(this.form.getMonthNumber()), Integer.parseInt(this.form.getWhatYear())));
        dataManager.dataAdder(this.coordinates.endDateCoordinates(), String.format("%02d.%02d.%d", this.form.getDays().get(this.form.getDays().size() - 1), Integer.parseInt(this.form.getMonthNumber()), Integer.parseInt(this.form.getWhatYear())));
        dataManager.dataAdder(this.coordinates.reasonCoordinates(), this.form.getReason());
        dataManager.dataAdder(this.coordinates.employerNameCoordinates(), this.form.getHeadEmployeeName());
        String ifEmptyPersonalNumber = this.form.getPersonalNumber().trim().isEmpty() || this.form.getPersonalNumber() == null ? "              " : this.form.getPersonalNumber();
        dataManager.dataAdder(this.coordinates.orderNumberCoordinates(), String.format("%s-%02d-%02d", ifEmptyPersonalNumber, Integer.parseInt(this.form.getMonthNumber()), Integer.parseInt(this.form.getTripNumberThisMonth())));
        dataManager.dataAdder(this.coordinates.businessTripFNumberCoordinates(), this.form.getBranchIn());
        dataManager.dataAdder(this.coordinates.difficultiesCoordinates(), this.form.getDificulties());
        return dataManager.data;
    }

    private void numberOfOrdersCreation(List<Integer> days, List<ImgData> data) {
        int ordersNeeded;
        int daysInOrder = this.configuration.getNumberOfDaysInOneOrder();
        int n = ordersNeeded = days.size() > daysInOrder ? 2 : 1;
        if (ordersNeeded == 2) {
            List<Integer> orderDaysSublist = days.subList(0, 8);
            this.drawDatesAndDestination(orderDaysSublist, data, this.blankImage, this.coordinates.arrivedDateCoordinates(), this.coordinates.departedDateCoordinates(), this.coordinates.destinationCoordinates());
            List<Integer> addDaysSublist = days.subList(8, days.size());
            DataManager addDaysManager = new DataManager(this.form, new ArrayList<ImgData>());
            addDaysManager.dataAdder(this.orderAdditionalDaysCoordinates.endDateCoordinates(), String.format("%02d.%02d.%d", addDaysSublist.get(addDaysSublist.size() - 1), Integer.parseInt(this.form.getMonthNumber()), Integer.parseInt(this.form.getWhatYear())));
            this.drawDatesAndDestination(addDaysSublist, addDaysManager.data, this.blankAdditionalOrderDaysImage, this.orderAdditionalDaysCoordinates.arrivedDateCoordinates(), this.orderAdditionalDaysCoordinates.departedDateCoordinates(), this.orderAdditionalDaysCoordinates.destinationCoordinates());
        } else {
            this.drawDatesAndDestination(days, data, this.blankImage, this.coordinates.arrivedDateCoordinates(), this.coordinates.departedDateCoordinates(), this.coordinates.destinationCoordinates());
        }
    }

    private void drawDatesAndDestination(List<Integer> days, List<ImgData> data, BufferedImage blankImage, List<TextCords> arrivedDateCoordinates, List<TextCords> departedDateCoordinates, List<TextCords> destinationCoordinates) {
        DataManager currentManager = new DataManager(this.form, data);
        this.addDaysAndDestination(days, currentManager, arrivedDateCoordinates, departedDateCoordinates, destinationCoordinates);
        BufferedImage currentImage = ImageDrawer.drawDataOnBackgroundImg(currentManager.data, blankImage, this.configuration.getFont(), this.configuration.getFontColor());
        this.sheetStorage.add(currentImage);
    }

    private void addDaysAndDestination(List<Integer> days, DataManager data, List<TextCords> arrivedDateCoordinates, List<TextCords> departedDateCoordinates, List<TextCords> destinationCoordinates) {
        ArrayList<Integer> daysToArray = new ArrayList<Integer>(days);
        for (int i = 0; i < days.size(); ++i) {
            data.dataAdder(arrivedDateCoordinates.get(i), String.format("%02d.%02d.%d", daysToArray.get(i), Integer.parseInt(this.form.getMonthNumber()), Integer.parseInt(this.form.getWhatYear())));
            data.dataAdder(departedDateCoordinates.get(i), String.format("%02d.%02d.%d", daysToArray.get(i), Integer.parseInt(this.form.getMonthNumber()), Integer.parseInt(this.form.getWhatYear())));
            data.dataAdder(destinationCoordinates.get(i), this.form.getEndDestination());
        }
    }
}

