/*
 * Decompiled with CFR 0.152.
 */
package org.example.engine;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.example.configuration.BusinessTripForm;
import org.example.configuration.IConfiguration;
import org.example.configuration.ITravelListTextCoordinates;
import org.example.engine.DataManager;
import org.example.engine.ImgData;
import org.example.utillity.ExpenseCalculator;
import org.example.utillity.ImageDrawer;

public class TravelListDataManager {
    private final BusinessTripForm form;
    private final List<BufferedImage> sheetStorage;
    private final IConfiguration config;
    private final ITravelListTextCoordinates coordinates;
    private BufferedImage blankImage;

    public TravelListDataManager(BusinessTripForm form, List<BufferedImage> sheetStorage, IConfiguration config, ITravelListTextCoordinates coordinates) {
        block9: {
            this.form = form;
            this.sheetStorage = sheetStorage;
            this.config = config;
            this.coordinates = coordinates;
            try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(config.travelImgResourcePath().get());){
                if (inputStream != null) {
                    this.blankImage = ImageIO.read(inputStream);
                    break block9;
                }
                throw new RuntimeException("Image resource not found");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void getTravelWithoutHotel() {
        BigDecimal totalFuelExpenses = ExpenseCalculator.calculateTotalFuelPrice(this.form.getKilometers(), this.form.getCostBy100(), this.form.getFuelPrice());
        if (totalFuelExpenses.compareTo(BigDecimal.ZERO) > 0) {
            DataManager dataManager = new DataManager(this.form, this.commonTravelData());
            this.dateReasonKilometersAdderWithoutNightStay(dataManager);
            this.sheetStorage.add(ImageDrawer.drawDataOnBackgroundImg(dataManager.data, this.blankImage, this.config.getFont(), this.config.getFontColor()));
        }
    }

    public void getTravelWithHotel() {
        BigDecimal totalFuelExpenses = ExpenseCalculator.calculateTotalFuelPrice(this.form.getKilometers(), this.form.getCostBy100(), this.form.getFuelPrice());
        if (totalFuelExpenses.compareTo(BigDecimal.ZERO) > 0) {
            DataManager dataManager = new DataManager(this.form, this.commonTravelData());
            this.dateReasonKilometersAdderWithNightStay(dataManager);
            this.sheetStorage.add(ImageDrawer.drawDataOnBackgroundImg(dataManager.data, this.blankImage, this.config.getFont(), this.config.getFontColor()));
        }
    }

    private List<ImgData> commonTravelData() {
        DataManager dataManager = new DataManager(this.form, new ArrayList<ImgData>());
        dataManager.dataAdder(this.coordinates.fullNameCoordinates(), this.form.getFullName());
        dataManager.dataAdder(this.coordinates.personalNumberCoordinates(), this.form.getPersonalNumber());
        dataManager.dataAdder(this.coordinates.vehicleMakeAndModelCoordinates(), String.format("%s %s", this.form.getMake(), this.form.getModel()));
        dataManager.dataAdder(this.coordinates.fuelConsumptionFor100Coordinates(), String.format("%.2f", this.form.getCostBy100()));
        dataManager.dataAdder(this.coordinates.vehicleRegNumberCoordinates(), this.form.getRegistrationNumber());
        dataManager.dataAdder(this.coordinates.fuelTypeCoordinates(), this.form.getFuelType());
        dataManager.dataAdder(this.coordinates.kilometersCoordinates(), this.form.getKilometers().toString());
        if (!"\u0443\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b".equals(this.form.getHeadEmployeeName())) {
            dataManager.dataAdder(this.coordinates.employerNameCoordinates(), this.form.getHeadEmployeeName());
        }
        dataManager.dataAdder(this.coordinates.monthAndYearCoordinates(), String.format("%s/%s", this.form.getMonthNumber(), this.form.getWhatYear()));
        return dataManager.data;
    }

    private void dateReasonKilometersAdderWithoutNightStay(DataManager dataManager) {
        BigDecimal kilometers = this.form.getKilometers().divide(this.form.getNumberOfDays(), 0, RoundingMode.FLOOR);
        for (int day = 0; day < this.form.getDays().size(); ++day) {
            if (!(this.form.getStartDestination() == null || this.form.getStartDestination().trim().isEmpty() || this.form.getEndDestination() == null || this.form.getEndDestination().trim().isEmpty() || this.form.getReason() == null || this.form.getReason().trim().isEmpty())) {
                dataManager.dataAdder(this.coordinates.destinationAndReasonCoordinates().get(day), String.format("%s-%s-%s/%s/", this.form.getStartDestination(), this.form.getEndDestination(), this.form.getStartDestination(), this.form.getReason()));
            }
            dataManager.dataAdder(this.coordinates.days().get(day), String.format("%02d.%02d.%d", this.form.getDays().get(day), Integer.parseInt(this.form.getMonthNumber()), Integer.parseInt(this.form.getWhatYear())));
            dataManager.dataAdder(this.coordinates.kilometersForEachDayCoordinates().get(day), String.valueOf(kilometers));
        }
    }

    private void dateReasonKilometersAdderWithNightStay(DataManager dataManager) {
        if (this.form.getIsTravelOnFirstDay() && this.form.getIsTravelOnLastDay()) {
            if (!(this.form.getStartDestination() == null || this.form.getStartDestination().trim().isEmpty() || this.form.getEndDestination() == null || this.form.getEndDestination().trim().isEmpty() || this.form.getReason() == null || this.form.getReason().trim().isEmpty())) {
                dataManager.dataAdder(this.coordinates.destinationAndReasonCoordinates().get(0), String.format("%s-%s/%s/", this.form.getStartDestination(), this.form.getEndDestination(), this.form.getReason()));
                dataManager.dataAdder(this.coordinates.destinationAndReasonWithNightStayCoordinates().get(1), String.format("%s-%s", this.form.getEndDestination(), this.form.getStartDestination()));
            }
            dataManager.dataAdder(this.coordinates.days().get(0), String.format("%02d.%02d.%d", this.form.getDays().get(0), Integer.parseInt(this.form.getMonthNumber()), Integer.parseInt(this.form.getWhatYear())));
            dataManager.dataAdder(this.coordinates.days().get(1), String.format("%02d.%02d.%d", this.form.getDays().get(this.form.getDays().size() - 1), Integer.parseInt(this.form.getMonthNumber()), Integer.parseInt(this.form.getWhatYear())));
            BigDecimal kilometers = this.form.getKilometers().divide(BigDecimal.valueOf(2L), 0, RoundingMode.FLOOR);
            dataManager.dataAdder(this.coordinates.kilometersForEachDayWithNightStayCoordinates().get(0), String.valueOf(kilometers));
            dataManager.dataAdder(this.coordinates.kilometersForEachDayWithNightStayCoordinates().get(1), String.valueOf(kilometers));
        }
        if (this.form.getIsTravelOnLastDay() && !this.form.getIsTravelOnFirstDay()) {
            if (this.form.getStartDestination() != null && !this.form.getStartDestination().trim().isEmpty() && this.form.getEndDestination() != null && !this.form.getEndDestination().trim().isEmpty()) {
                dataManager.dataAdder(this.coordinates.destinationAndReasonWithNightStayCoordinates().get(0), String.format("%s-%s", this.form.getEndDestination(), this.form.getStartDestination()));
            }
            dataManager.dataAdder(this.coordinates.days().get(0), String.format("%02d.%02d.%d", this.form.getDays().get(this.form.getDays().size() - 1), Integer.parseInt(this.form.getMonthNumber()), Integer.parseInt(this.form.getWhatYear())));
            dataManager.dataAdder(this.coordinates.kilometersForEachDayWithNightStayCoordinates().get(0), String.valueOf(this.form.getKilometers()));
        }
        if (this.form.getIsTravelOnFirstDay() && !this.form.getIsTravelOnLastDay()) {
            if (!(this.form.getStartDestination() == null || this.form.getStartDestination().trim().isEmpty() || this.form.getEndDestination() == null || this.form.getEndDestination().trim().isEmpty() || this.form.getReason() == null || this.form.getReason().trim().isEmpty())) {
                dataManager.dataAdder(this.coordinates.destinationAndReasonCoordinates().get(0), String.format("%s-%s/%s/", this.form.getStartDestination(), this.form.getEndDestination(), this.form.getReason()));
            }
            dataManager.dataAdder(this.coordinates.days().get(0), String.format("%02d.%02d.%d", this.form.getDays().get(0), Integer.parseInt(this.form.getMonthNumber()), Integer.parseInt(this.form.getWhatYear())));
            dataManager.dataAdder(this.coordinates.kilometersForEachDayWithNightStayCoordinates().get(0), String.valueOf(this.form.getKilometers()));
        }
    }
}

