/*
 * Decompiled with CFR 0.152.
 */
package org.example.engine;

import java.awt.image.BufferedImage;
import java.util.List;
import org.example.configuration.BusinessTripForm;
import org.example.configuration.IConfiguration;
import org.example.configuration.IOrderAdditionalDaysCoordinates;
import org.example.configuration.IOrderTextCoordinates;
import org.example.configuration.ITravelListTextCoordinates;
import org.example.engine.OrderListDataManager;
import org.example.engine.TravelListDataManager;

public class TripTypeSelector {
    private IOrderTextCoordinates orderCoordinates;
    private final IOrderAdditionalDaysCoordinates orderAdditionalDaysCoordinates;
    private final ITravelListTextCoordinates travelListTextCoordinates;

    public TripTypeSelector(IOrderTextCoordinates orderCoordinates, IOrderAdditionalDaysCoordinates orderAdditionalDaysCoordinates, ITravelListTextCoordinates travelListTextCoordinates) {
        this.orderCoordinates = orderCoordinates;
        this.orderAdditionalDaysCoordinates = orderAdditionalDaysCoordinates;
        this.travelListTextCoordinates = travelListTextCoordinates;
    }

    public void select(BusinessTripForm form, List<BufferedImage> sheetStorage, IConfiguration configuration) {
        OrderListDataManager orderDataManager = new OrderListDataManager(form, sheetStorage, configuration, this.orderCoordinates, this.orderAdditionalDaysCoordinates);
        TravelListDataManager travelDataManager = new TravelListDataManager(form, sheetStorage, configuration, this.travelListTextCoordinates);
        boolean isTravelWithOtherTransport = form.getIsTravelWithOtherTransport();
        boolean isWithHotelStay = form.getIsNightStayedInHotel();
        boolean isTravelWithYourVehicle = form.getIsTravelWithYourVehicle();
        if (isWithHotelStay) {
            if (isTravelWithYourVehicle) {
                orderDataManager.getTripWithVehicleWithHotel();
                travelDataManager.getTravelWithHotel();
            } else if (isTravelWithOtherTransport) {
                orderDataManager.getTripWithOtherTransportWithHotel();
            } else {
                orderDataManager.getTripWithoutVehicleWithHotel();
            }
        } else if (isTravelWithYourVehicle) {
            orderDataManager.getTripWithVehicleWithoutHotel();
            travelDataManager.getTravelWithoutHotel();
        } else if (isTravelWithOtherTransport) {
            orderDataManager.getTripWithOtherTransportWithoutHotel();
        } else {
            orderDataManager.getTripWithoutVehicleWithoutHotel();
        }
    }
}

